//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Reflection;

namespace LateBinding
{
	/// <summary>
	/// Podsumowanie dla LateBindingMain.
	/// </summary>
	class LateBindingMain
	{
		static void Main(string[] args)
		{
			Assembly first = Assembly.LoadFrom(@"..\..\First\bin\debug\first.dll");
			Assembly second = Assembly.LoadFrom(@"..\..\Second\bin\debug\second.dll");
			Assembly [] assemblies = new Assembly[] { first, second };
			foreach(Assembly a in assemblies)
			{
				Type[] types = a.GetTypes();
				foreach(Type t in types)
				{
					try
					{
						object o = Activator.CreateInstance(t);
						MethodInfo m = t.GetMethod("OutputMessage");
						m.Invoke(o, new object [] {"To jest moja wiadomo"});
					}
					catch(Exception e)
					{
						Console.WriteLine(e);
					}
				}
			}
		}
	}
}
